//=============================================================================
// Change_Confusion_Custom_MZ.js
//   Last update: 2025/10/01
//=============================================================================
// 更新っぽいもの
// 
// 2025/10/01 [v0.1.0]
// 初版

/*:
 * @target MZ
 * 
 * @plugindesc
 * [v0.1.0] Change!! Confusion_Custom MZ.
 * 
 * @author Diamond
 *
 * @param Use Guard Flg
 * @text ????
 * @default true
 * @type boolean
 * @on Use.
 * @off Not Use.
 * @desc
 * English is not supported.
 * Please Use Japanese!!
 *
 * @param Use Escape Flg
 * @text ????
 * @default true
 * @type boolean
 * @on Use.
 * @off Not Use.
 * @desc
 * English is not supported.
 * Please Use Japanese!!
 *
 * @param Escape Skill ID
 * @text ????
 * @default 15
 * @type skill
 * @desc
 * English is not supported.
 * Please Use Japanese!!
 * @parent Use Escape Flg
 *
 * @param Use No Action Flg
 * @text ????
 * @default true
 * @type boolean
 * @on Use.
 * @off Not Use.
 * @desc
 * English is not supported.
 * Please Use Japanese!!
 *
 * @param No Action Skill ID
 * @text ????
 * @default 16
 * @type skill
 * @desc
 * English is not supported.
 * Please Use Japanese!!
 * @parent Use No Action Flg
 * 
 * @help
 * Diamond use ruby, not use Java Script!!
 * Please use Ruby!! and RPG Tkool XP/VX/VX Ace.
 * 
 * @url https://diamond.iza-yoi.net/
 */

/*:ja
 * @target MZ
 * 
 * @plugindesc
 * [v0.1.0] 真（チェンジ！！）混乱拡張 MZ
 * 
 * @author 貪藻矢射妥←
 *
 * @param Use Guard Flg
 * @text 混乱時、防御するか
 * @default true
 * @type boolean
 * @on 使う
 * @off 使わない
 * @desc
 * 混乱時、防御するかどうか
 *
 * @param Use Escape Flg
 * @text 混乱時、逃走するか
 * @default true
 * @type boolean
 * @on 使う
 * @off 使わない
 * @desc
 * 混乱時、逃走するかどうか
 *
 * @param Escape Skill ID
 * @text 「逃げる」のスキルID
 * @default 15
 * @type skill
 * @desc
 * 「逃げる」のスキルID
 * ※混乱時、逃走を使う場合に必要
 * @parent Use Escape Flg
 *
 * @param Use No Action Flg
 * @text 混乱時、傍観するか
 * @default true
 * @type boolean
 * @on 使う
 * @off 使わない
 * @desc
 * 混乱時、傍観するかどうか
 *
 * @param No Action Skill ID
 * @text 「様子見」のスキルID
 * @default 16
 * @type skill
 * @desc
 * 「様子見」のスキルID
 * ※混乱時、傍観する場合に必要
 * @parent Use No Action Flg
 *
 * @help
 * 混乱時のアクションを拡張します。
 * 混乱時に「防御」、「逃げる」、「様子見」を追加します。
 * 
 * ※注意※
 * 混乱時の「逃げる」について
 * アクターの逃走は戦闘が終了する場合と一部のアクターが個別で逃走する
 * 場合のどちらかが実施されます。（先頭キャラクターかそうでないか？）
 * これはバトルが以下の順番で行われており、順番を変えることができない
 * ため起こる事象になります。
 * 1)対象ターゲットの選定
 * 2)スキルの実行
 * 順番を変えることが出来ない以上そういう仕様だと思ってください。
 * 
 * 混乱時の「様子見」について
 * 混乱の際に「様子見」すると、行動失敗時のメッセージも出力されます。
 * 行動失敗時のメッセージが出ないようにしたかったのですがうまくいかず、
 * またJava Scriptでそこまでする気力がないため、そういう仕様だと思って
 * ください。
 *
 * Java ScriptよりもRubyを使いたい！ by 貪藻矢射妥←
 * 
 * @url https://diamond.iza-yoi.net/
 */

var OuterFlg = OuterFlg || {};

(() => {

'use strict';

OuterFlg.imported = OuterFlg.imported || {};
OuterFlg.imported['Confusion_Custom'] = true;

var pluginParams = PluginManager.parameters('Change_Confusion_Custom_MZ');
var changeConfusionCustomUseGuardFlg     = Boolean(pluginParams['Use Guard Flg'] || true);
var changeConfusionCustomUseEscapeFlg    = Boolean(pluginParams['Use Escape Flg'] || true);
var changeConfusionCustomEscapeSkillId   = Number(pluginParams['Escape Skill ID'] || 15);
var changeConfusionCustomUseNoActionFlg  = Boolean(pluginParams['Use No Action Flg'] || true);
var changeConfusionCustomNoActionSkillId = Number(pluginParams['No Action Skill ID'] || 16);

Game_BattlerBase.ATTACK_SKILL_ID    = 1;
Game_BattlerBase.GUARD_SKILL_ID     = 2;

Game_BattlerBase.CONFUSION_ACTION_ATTACK    = 0;
Game_BattlerBase.CONFUSION_ACTION_GUARD     = 1;
Game_BattlerBase.CONFUSION_ACTION_ESCAPE    = 2;
Game_BattlerBase.CONFUSION_ACTION_SKILL     = 3; // 予備
Game_BattlerBase.CONFUSION_ACTION_ITEM      = 4; // 予備
Game_BattlerBase.CONFUSION_ACTION_NO_ACTION = 5;


/* 
 * 混乱時のアクションの設定
 */
var getConfusionActionList = function() {
    var list = [];
    list.push(Game_BattlerBase.CONFUSION_ACTION_ATTACK);
    
    if( changeConfusionCustomUseGuardFlg ) {
        list.push(Game_BattlerBase.CONFUSION_ACTION_GUARD);
    }
    if( changeConfusionCustomUseEscapeFlg ) {
        list.push(Game_BattlerBase.CONFUSION_ACTION_ESCAPE);
    }
    if( changeConfusionCustomUseNoActionFlg ) {
        list.push(Game_BattlerBase.CONFUSION_ACTION_NO_ACTION);
    }
    return list;
};


//-----------------------------------------------------------------------------
// Game_Action

Game_Action.prototype.setEscape = function() {
    this._item.setObject($dataSkills[changeConfusionCustomEscapeSkillId]);
};

Game_Action.prototype.setNoAction = function() {
    this._item.setObject($dataSkills[changeConfusionCustomNoActionSkillId]);
};

Game_Action.prototype.getEnemySkillList = function(actions) {
    var list = [];
    for (const enemyAct of actions) {
        if( enemyAct.skillId !== Game_BattlerBase.ATTACK_SKILL_ID && 
            enemyAct.skillId !== Game_BattlerBase.GUARD_SKILL_ID && 
            enemyAct.skillId !== changeConfusionCustomEscapeSkillId && 
            enemyAct.skillId !== changeConfusionCustomNoActionSkillId ) {
            // 攻撃、防御、逃げる、様子見以外のスキルを抽出
            list.push(enemyAct);
        }
    }
    return list;
};

Game_Action.prototype.setConfusion = function() {
    var confusionActionList = getConfusionActionList();
    
    var index = Math.randomInt(confusionActionList.length);
    switch (confusionActionList[index]) {
        case Game_BattlerBase.CONFUSION_ACTION_ATTACK: // 攻撃
            this.setAttack();
            break;
        case Game_BattlerBase.CONFUSION_ACTION_GUARD: // 防御
            this.setGuard();
            break;
        case Game_BattlerBase.CONFUSION_ACTION_ESCAPE: // 逃げる
            if(this.subject().isActor()) {
                this.setEscape();
            } else {
                this.setEscape();
            }
            break;
        case Game_BattlerBase.CONFUSION_ACTION_NO_ACTION: // 様子見
        defaut: // その他・異常時
            this.setNoAction();
            break;
    }
    
};

})();
