//=============================================================================
// Change_NoItem_NoUse_MZ.js
//   Last update: 2025/12/01
//=============================================================================
// 更新っぽいもの
// 
// 2025/12/01 [v0.1.0]
// 初版

/*:
 * @target MZ
 * 
 * @plugindesc
 * [v0.1.0] Change!! NoItem NoUse MZ.
 * 
 * @author Diamond
 *
 * @param NoUtem NoUse State ID
 * @text ????
 * @default 31
 * @type state
 * @desc
 * English is not supported.
 * Please Use Japanese!!
 *
 * @param NoUtem NoUse Item ID
 * @text ????
 * @default 2
 * @type item
 * @desc
 * English is not supported.
 * Please Use Japanese!!
 * 
 * @help
 * Diamond use ruby, not use Java Script!!
 * Please use Ruby!! and RPG Tkool XP/VX/VX Ace.
 * 
 * @url https://diamond.iza-yoi.net/
 */

/*:ja
 * @target MZ
 * 
 * @plugindesc
 * [v0.1.0] 真（チェンジ！！）アイテムなんぞ使ってんじゃねぇ！ MZ
 * 
 * @author 貪藻矢射妥←
 *
 * @param NoUtem NoUse State ID
 * @text アイテム使用禁止のステートID
 * @default 31
 * @type state
 * @desc
 * アイテム使用禁止のステートID
 *
 * @param NoUtem NoUse Item ID
 * @text アイテム使用禁止時に使用するアイテムID
 * @default 2
 * @type item
 * @desc
 * アイテム使用禁止時に使用するアイテムID
 *
 * @help
 * テイ○ズでお馴染みのアイテムを使おうとすると手痛いダメージを喰らうアレです。
 * アイテム使用禁止のステートとその際に使う自分自身にダメージを与えるアイテムを
 * 設定してください。
 * 
 * アイテム使用禁止時に使うアイテムは以下の様に設定してください。
 * 名　　　前：アイテムなんぞ使ってんじゃねぇ！
 * 消　　　耗：なし
 * 範　　　囲：使用者
 * 使用可能時：バトル
 * ダメージ-タイプ：HPダメージ
 * ダメージ-属　性：お好きなように
 * ダメージ-計算式：お好きなように
 * 使用効果：ステート解除でアイテム使用禁止のステートIDを100%解除
 *
 * Java ScriptよりもRubyを使いたい！ by 貪藻矢射妥←
 * 
 * @url https://diamond.iza-yoi.net/
 */

var OuterFlg = OuterFlg || {};

(() => {

OuterFlg.imported = OuterFlg.imported || {};
OuterFlg.imported['NoItem_NoUse'] = true;

var pluginParams = PluginManager.parameters('Change_NoItem_NoUse_MZ');
var changeNoItemNoUseStateID = Number(pluginParams['NoUtem NoUse State ID'] || 31);
var changeNoItemNoUseItemID  = Number(pluginParams['NoUtem NoUse Item ID'] || 2);


//-----------------------------------------------------------------------------
// BattleManager

BattleManager.startAction = function() {
    const subject = this._subject;
    const action = subject.currentAction();
    const targets = action.makeTargets();
    this._phase = "action";
    this._action = action;
    this._targets = targets;
    subject.cancelMotionRefresh();
    
    if( subject.states().includes($dataStates[changeNoItemNoUseStateID]) && 
        DataManager.isItem(action.item()) ) {
        // アイテム使用禁止、かつアイテムの場合
        subject.useItem($dataItems[changeNoItemNoUseItemID]);
    } else {
        // 元の処理
        subject.useItem(action.item());
    }
    
    this._action.applyGlobal();
    this._logWindow.startAction(subject, action, targets);
};

//-----------------------------------------------------------------------------
// Window_BattleLog

Window_BattleLog.prototype.startAction = function(subject, action, targets) {
    if ( subject.states().includes($dataStates[changeNoItemNoUseStateID]) && 
         DataManager.isItem(action.item()) ) {
        // アイテム使用禁止、かつアイテムの場合
        var tmp_item = $dataItems[changeNoItemNoUseItemID];
    } else {
        // 元の処理
        var tmp_item = action.item();
    }
    
    const item = tmp_item;
    this.push("performActionStart", subject, action);
    this.push("waitForMovement");
    this.push("performAction", subject, action);
    this.push("showAnimation", subject, targets.clone(), item.animationId);
    this.displayAction(subject, item);
};

Window_BattleLog.prototype.displayAction = function(subject, item) {
    const numMethods = this._methods.length;
    if (DataManager.isSkill(item)) {
        this.displayItemMessage(item.message1, subject, item);
        this.displayItemMessage(item.message2, subject, item);
    } else {
        if ( subject.states().includes($dataStates[changeNoItemNoUseStateID]) ) {
            // アイテム使用禁止の場合
            this.push("addText", item.name);
        } else {
            // 元の処理
            this.displayItemMessage(TextManager.useItem, subject, item);
        }
    }
    if (this._methods.length === numMethods) {
        this.push("wait");
    }
};

//-----------------------------------------------------------------------------
// Game_Action

Game_Action.prototype.apply = function(target) {
    const result = target.result();
    this.subject().clearResult();
    result.clear();
    result.used = this.testApply(target);
    result.missed = result.used && Math.random() >= this.itemHit(target);
    result.evaded = !result.missed && Math.random() < this.itemEva(target);
    result.physical = this.isPhysical();
    result.drain = this.isDrain();
    if (result.isHit()) {
        
        if ( this.subject().states().includes($dataStates[changeNoItemNoUseStateID]) && 
             DataManager.isItem(this.item()) ) {
            // アイテム使用禁止、かつアイテムの場合
            var tmp_item = $dataItems[changeNoItemNoUseItemID];
        } else {
            // 元の処理
            var tmp_item = this.item();
        }
        
        if (tmp_item.damage.type > 0) {
            result.critical = Math.random() < this.itemCri(target);
            const value = this.makeDamageValue(target, result.critical);
            this.executeDamage(target, value);
        }
        for (const effect of tmp_item.effects) {
            this.applyItemEffect(target, effect);
        }
        this.applyItemUserEffect(target);
    }
    this.updateLastTarget(target);
};

Game_Action.prototype.itemCri = function(target) {
    if ( this.subject().states().includes($dataStates[changeNoItemNoUseStateID]) && 
         DataManager.isItem(this.item()) ) {
        // アイテム使用禁止、かつアイテムの場合
        var tmp_item = $dataItems[changeNoItemNoUseItemID];
    } else {
        // 元の処理
        var tmp_item = this.item();
    }
    return tmp_item.damage.critical
        ? this.subject().cri * (1 - target.cev)
        : 0;
};

Game_Action.prototype.makeDamageValue = function(target, critical) {
    if ( this.subject().states().includes($dataStates[changeNoItemNoUseStateID]) && 
         DataManager.isItem(this.item()) ) {
        // アイテム使用禁止、かつアイテムの場合
        var tmp_item = $dataItems[changeNoItemNoUseItemID];
    } else {
        // 元の処理
        var tmp_item = this.item();
    }
        
    const item = tmp_item;
    const baseValue = this.evalDamageFormula(target);
    let value = baseValue * this.calcElementRate(target);
    if (this.isPhysical()) {
        value *= target.pdr;
    }
    if (this.isMagical()) {
        value *= target.mdr;
    }
    if (baseValue < 0) {
        value *= target.rec;
    }
    if (critical) {
        value = this.applyCritical(value);
    }
    value = this.applyVariance(value, item.damage.variance);
    value = this.applyGuard(value, target);
    value = Math.round(value);
    return value;
};

Game_Action.prototype.evalDamageFormula = function(target) {
    try {
        if ( this.subject().states().includes($dataStates[changeNoItemNoUseStateID]) && 
              DataManager.isItem(this.item()) ) {
            // アイテム使用禁止、かつアイテムの場合
            var tmp_item = $dataItems[changeNoItemNoUseItemID];
        } else {
            // 元の処理
            var tmp_item = this.item();
        }
        
        const item = tmp_item;
        const a = this.subject();       // eslint-disable-line no-unused-vars
        const b = target;               // eslint-disable-line no-unused-vars
        const v = $gameVariables._data; // eslint-disable-line no-unused-vars
        const sign = [3, 4].includes(item.damage.type) ? -1 : 1;
        const value = Math.max(eval(item.damage.formula), 0) * sign;
        return isNaN(value) ? 0 : value;
    } catch (e) {
        return 0;
    }
};

Game_Action.prototype.calcElementRate = function(target) {
    if ( this.subject().states().includes($dataStates[changeNoItemNoUseStateID]) && 
         DataManager.isItem(this.item()) ) {
        // アイテム使用禁止、かつアイテムの場合
        var tmp_item = $dataItems[changeNoItemNoUseItemID];
    } else {
        // 元の処理
        var tmp_item = this.item();
    }
    
    if (tmp_item.damage.elementId < 0) {
        return this.elementsMaxRate(target, this.subject().attackElements());
    } else {
        return target.elementRate(tmp_item.damage.elementId);
    }
};

Game_Action.prototype.checkDamageType = function(list) {
    if ( this.subject().states().includes($dataStates[changeNoItemNoUseStateID]) && 
         DataManager.isItem(this.item()) ) {
        // アイテム使用禁止、かつアイテムの場合
        var tmp_item = $dataItems[changeNoItemNoUseItemID];
    } else {
        // 元の処理
        var tmp_item = this.item();
    }
    return list.includes(tmp_item.damage.type);
};


})();
