//=============================================================================
// Change_Ex_SkillCost_MZ.js
//   Last update: 2025/12/01
//=============================================================================
// 更新っぽいもの
// 
// 2025/12/01 [v0.1.0]
// 初版

/*:
 * @target MZ
 * 
 * @plugindesc
 * [v0.1.0] Change!! Ex_SkillCost MZ.
 * 
 * @author Diamond
 *
 * @param HP Cost Color
 * @text ????
 * @default 10
 * @type color
 * @desc
 * English is not supported.
 * Please Use Japanese!!
 * 
 * @help
 * Diamond use ruby, not use Java Script!!
 * Please use Ruby!! and RPG Tkool XP/VX/VX Ace.
 * 
 * @url https://diamond.iza-yoi.net/
 */

/*:ja
 * @target MZ
 * 
 * @plugindesc
 * [v0.1.0] 真（チェンジ！！）特殊消費スキル MZ
 * 
 * @author 貪藻矢射妥←
 *
 * @param HP Cost Color
 * @text HP消費スキルのコストカラー
 * @default 10
 * @type color
 * @desc HP消費/HP割合消費スキルのコストカラー
 *
 * @help
 * MP割合消費/HP消費/HP割合消費のスキルを実装します。
 * 
 * スキルのメモ欄に以下を記載することで特殊消費スキルになります。
 * <SkillCost_MP_ratio>　MP割合消費スキル
 * <SkillCost_HP_sensus>　HP消費スキル
 * <SkillCost_HP_ratio>　HP割合消費スキル
 * ※ratio（ラティオ）とsensus（センサス）なのは、ラティオの対はセンサス
 * 　だろうというテイ○ズ・オブ・イノセンス的な発想です。
 * 
 * ※注意※
 * 本プラグインは以下のプラグインを併用しています。
 * Change_Definition_Number_MZ
 * 貪藻矢射妥←の魔で公開中ですので、DLして導入してください。
 *
 * Java ScriptよりもRubyを使いたい！ by 貪藻矢射妥←
 * 
 * @url https://diamond.iza-yoi.net/
 */


var OuterFlg = OuterFlg || {};

(() => {

'use strict';

OuterFlg.imported = OuterFlg.imported || {};
OuterFlg.imported['Ex_SkillCost'] = true;

var pluginParams                 = PluginManager.parameters('Change_Ex_SkillCost_MZ');
var changeExSkillCostHpCostColor = Number(pluginParams['HP Cost Color'] || 10);

//var ParamsEx          = PluginManagerEx.createParameter(document.currentScript);
//var ParamsEx_hogehoge = ParamsEx['hogehogeStruct'];


//-----------------------------------------------------------------------------
// Window_SkillList

Window_SkillList.prototype.drawSkillCost = function(skill, x, y, width) {
    if (this._actor.skillTpCost(skill) > 0) {
        this.changeTextColor(ColorManager.tpCostColor());
        this.drawText(this._actor.skillTpCost(skill), x, y, width, Window_Base.DRAW_ALIGN_RIGHT);
    } else if (this._actor.skillMpCost(skill) > 0) {
        if ( skill.meta.SkillCost_HP_sensus || skill.meta.SkillCost_HP_ratio ) {
            this.changeTextColor(ColorManager.hpCostColor());
        } else {
            this.changeTextColor(ColorManager.mpCostColor());
        }
        this.drawText(this._actor.skillMpCost(skill), x, y, width, Window_Base.DRAW_ALIGN_RIGHT);
    }
};


//-----------------------------------------------------------------------------
// ColorManager

ColorManager.hpCostColor = function() {
    return this.textColor(changeExSkillCostHpCostColor);
};


//-----------------------------------------------------------------------------
// Game_BattlerBase

Game_BattlerBase.prototype.skillMpCost = function(skill) {
    var skillMpCost = skill.mpCost;
    
    if ( skill.meta.SkillCost_HP_ratio ) {
        skillMpCost = skill.mpCost * this.param(Game_BattlerBase.PARAM_TYPE_HP) / 100;
    }
    if ( skill.meta.SkillCost_MP_ratio ) {
        skillMpCost = skill.mpCost * this.param(Game_BattlerBase.PARAM_TYPE_MP) / 100;
    }
    return Math.floor(skillMpCost * this.mcr);
};

Game_BattlerBase.prototype.canPaySkillCost = function(skill) {
    if (this.skillTpCost(skill) > 0) {
        return this._tp >= this.skillTpCost(skill);
    } else if (this.skillMpCost(skill) > 0) {
        if ( skill.meta.SkillCost_HP_sensus || skill.meta.SkillCost_HP_ratio ) {
            return this._hp >= this.skillMpCost(skill);
        } else {
            return this._mp >= this.skillMpCost(skill);
        }
    } else {
        return true;
    }
};

Game_BattlerBase.prototype.paySkillCost = function(skill) {
    var hpCostFlg = false;
    if ( skill.meta.SkillCost_HP_sensus || skill.meta.SkillCost_HP_ratio ) {
        hpCostFlg = true;
    }
    if ( hpCostFlg ) {
        this._hp -= this.skillMpCost(skill);
    } else {
        this._mp -= this.skillMpCost(skill);
    }
    this._tp -= this.skillTpCost(skill);
};


})();
