//=============================================================================
// Change_Definition_Number_MZ.js
//   Last update: 2025/12/01
//=============================================================================
// 更新っぽいもの
// 
// 2025/12/01 [v0.1.0]
// 初版

/*:
 * @target MZ
 * 
 * @plugindesc
 * [v0.1.0] Change!! Definition Number MZ.
 * 
 * @author Diamond
 * 
 * @help
 * Diamond use ruby, not use Java Script!!
 * Please use Ruby!! and RPG Tkool XP/VX/VX Ace.
 * 
 * @url https://diamond.iza-yoi.net/
 */

/*:ja
 * @target MZ
 * 
 * @plugindesc
 * [v0.1.0] 真（チェンジ！！）マジックナンバーの定義化 MZ
 * 
 * @author 貪藻矢射妥←
 *
 *
 * @help
 * マジックナンバーを定義化します。
 * コアスクリプトも変えろとは言いませんが、せめて自作プラグインくらいは
 * 定義値を使いましょう
 * 
 * ※注意※
 * なるべく上の方に導入してください。
 * 
 * 定義値一覧
 *  アイテム/スキル 使用可能時(occasion)
 * Game_BattlerBase.OCCASION_ALL    = 0;　使用可能時：常時
 * Game_BattlerBase.OCCASION_BATTLE = 1;　使用可能時：戦闘中
 * Game_BattlerBase.OCCASION_MENU   = 2;　使用可能時：メニュー時
 * Game_BattlerBase.OCCASION_NONE   = 3;　使用可能時：なし
 * 
 *  アイテム/スキル 効果範囲(scope)
 * Game_Action.SCOPE_NONE             = 0; 　効果範囲：なし
 * Game_Action.SCOPE_ENEMY_OME        = 1; 　効果範囲：敵単体
 * Game_Action.SCOPE_ENEMY_ALL        = 2; 　効果範囲：敵全体
 * Game_Action.SCOPE_ENEMY_RND1       = 3; 　効果範囲：敵1体ランダム
 * Game_Action.SCOPE_ENEMY_RND2       = 4; 　効果範囲：敵2体ランダム
 * Game_Action.SCOPE_ENEMY_RND3       = 5; 　効果範囲：敵3体ランダム
 * Game_Action.SCOPE_ENEMY_RND4       = 6; 　効果範囲：敵4体ランダム
 * Game_Action.SCOPE_FRIEND_ALIVE_ONE = 7; 　効果範囲：味方単体（生存）
 * Game_Action.SCOPE_FRIEND_ALIVE_ALL = 8; 　効果範囲：味方全体（生存）
 * Game_Action.SCOPE_FRIEND_DEAD_ONE  = 9; 　効果範囲：味方単体（戦闘不能）
 * Game_Action.SCOPE_FRIEND_DEAD_ALL  = 10;　効果範囲：味方全体（戦闘不能）
 * Game_Action.SCOPE_USER             = 11;　効果範囲：使用者
 * Game_Action.SCOPE_FRIEND_EXTRA_ONE = 12;　効果範囲：味方単体（無条件）
 * Game_Action.SCOPE_FRIEND_EXTRA_ALL = 13;　効果範囲：味方全体（無条件）
 * Game_Action.SCOPE_ALL_OF_ALL       = 14;　効果範囲：敵味方全体
 * 
 *  ステート制約(restriction)
 * Game_BattlerBase.RESTRICTION_NONE        = 0;　制約：なし
 * Game_BattlerBase.RESTRICTION_CONF_ENEMY  = 1;　制約：敵を攻撃
 * Game_BattlerBase.RESTRICTION_CONF_ALL    = 2;　制約：誰かを攻撃
 * Game_BattlerBase.RESTRICTION_CONF_FRIEND = 3;　制約：味方を攻撃
 * Game_BattlerBase.RESTRICTION_NO_ACTION   = 4;　制約：行動不能
 *
 * Java ScriptよりもRubyを使いたい！ by 貪藻矢射妥←
 * 
 * @url https://diamond.iza-yoi.net/
 */

var OuterFlg = OuterFlg || {};

(() => {

OuterFlg.imported = OuterFlg.imported || {};
OuterFlg.imported['Definition_Number'] = true;

//var pluginParams = PluginManager.parameters('Change_Definition_Number_MZ');
//var hogehoge      = pluginParams['hogehoge'] || 'error_log';

// アイテム/スキル 使用可能時(occasion)
Game_BattlerBase.OCCASION_ALL    = 0;
Game_BattlerBase.OCCASION_BATTLE = 1;
Game_BattlerBase.OCCASION_MENU   = 2;
Game_BattlerBase.OCCASION_NONE   = 3;

// アイテム/スキル 効果範囲(scope)
Game_Action.SCOPE_NONE             = 0;
Game_Action.SCOPE_ENEMY_OME        = 1;
Game_Action.SCOPE_ENEMY_ALL        = 2;
Game_Action.SCOPE_ENEMY_RND1       = 3;
Game_Action.SCOPE_ENEMY_RND2       = 4;
Game_Action.SCOPE_ENEMY_RND3       = 5;
Game_Action.SCOPE_ENEMY_RND4       = 6;
Game_Action.SCOPE_FRIEND_ALIVE_ONE = 7;
Game_Action.SCOPE_FRIEND_ALIVE_ALL = 8;
Game_Action.SCOPE_FRIEND_DEAD_ONE  = 9;
Game_Action.SCOPE_FRIEND_DEAD_ALL  = 10;
Game_Action.SCOPE_USER             = 11;
Game_Action.SCOPE_FRIEND_EXTRA_ONE = 12;
Game_Action.SCOPE_FRIEND_EXTRA_ALL = 13;
Game_Action.SCOPE_ALL_OF_ALL       = 14;

// ステート制約(restriction)
Game_BattlerBase.RESTRICTION_NONE        = 0;
Game_BattlerBase.RESTRICTION_CONF_ENEMY  = 1;
Game_BattlerBase.RESTRICTION_CONF_ALL    = 2;
Game_BattlerBase.RESTRICTION_CONF_FRIEND = 3;
Game_BattlerBase.RESTRICTION_NO_ACTION   = 4;


})();
